CREATE TABLE IF NOT EXISTS x_10_interfaces.grafana_elements (
    graf_id         SERIAL PRIMARY KEY,     -- Eindeutige ID
    graf_elem_type  varchar(50) NOT null,   -- Typ des Elements (z. B. 'dashboard', 'datasource', 'folder', 'alert_channel')
    graf_elem_uid   varchar(255),           -- UID des Elements (falls verfügbar, z. B. für Dashboards)
    graf_elem_title varchar(255) NOT null,  -- Titel oder Name des Elements
    graf_elem_json  jsonb NOT null,         -- Das JSON-Dokument des Elements
    graf_elem_kunde varchar,                -- Liste der Kunden, für die das Element erstellt wurde
    CONSTRAINT unique_element UNIQUE (graf_elem_type, graf_elem_uid)
);